#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_Address : BaseTest 
	{
		
		private DataTable _dtFacility;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtFacility = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Facility WHERE AddressGuid IS NOT NULL", true);

				this.RefreshData = false;
			}

		}

		[Test]
		public void GetAddress_Pass()
		{
			DataRow drCheck = DAL.Address.GetAddress((System.Guid)this._dtFacility.Rows[0][TABLES.Facility.FacilityGuid]);

			Assert.AreEqual(8, drCheck.Table.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.Address.AddressGuid), TABLES.Address.AddressGuid);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.Address.AddressLine1), TABLES.Address.AddressLine1);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.Address.AddressLine2), TABLES.Address.AddressLine2);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.Address.AddressLine3), TABLES.Address.AddressLine3);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.Address.AddressCity), TABLES.Address.AddressCity);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.Address.StateCode), TABLES.Address.StateCode);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.Address.AddressZipCode), TABLES.Address.AddressZipCode);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.Address.RowVersion), TABLES.Address.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAddress_Fail()
		{
		}

		[Test]
		public void GetEmptyAddressTableSchema_Pass()
		{
			DataTable dtTest = DAL.Address.GetEmptyAddressTableSchema(true);

			Assert.AreEqual(TABLES.Address.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(8, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressGuid), TABLES.Address.AddressGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressLine1), TABLES.Address.AddressLine1);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressLine2), TABLES.Address.AddressLine2);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressLine3), TABLES.Address.AddressLine3);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressCity), TABLES.Address.AddressCity);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.StateCode), TABLES.Address.StateCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressZipCode), TABLES.Address.AddressZipCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.AddressRowVersion), ARTIFICIAL.AddressRowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEmptyAddressTableSchema_Fail()
		{
		}

	}
}
#endif
